﻿Function New-ModuleDrives
{
<#
    .SYNOPSIS
    Tworzy dwa dyski PSDrive: myMods i sysMods
    .EXAMPLE
    New-ModuleDrives
    Tworzy dwa dyski PSDrive: myMods i sysMods. Reprezentują one 
    odpowiednio foldery z modułami użytkownika i systemowy. 
#>
 $driveNames = "myMods","sysMods"

 For($i = 0 ; $i -le 1 ; $i++)
 {
  New-PSDrive -name $driveNames[$i] -PSProvider filesystem `
  -Root ($env:PSModulePath.split(";")[$i]) -scope Global |
  Out-Null
 } #end For
} #end New-ModuleDrives

Function Get-FileSystemDrives
{
<#
    .SYNOPSIS
    Wyświetla globalne dyski PowerShell używające dostawcy Filesystem.
    .EXAMPLE
    Get-FileSystemDrives
    Wyświetla globalne dyski PowerShell używające dostawcy Filesystem.
#>
 Get-PSDrive -PSProvider FileSystem -scope Global
} #end Get-FileSystemDrives

# *** punkt początkowy skryptu ***
New-ModuleDrives
Get-FileSystemDrives